<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:variable name="exportType">CSV</xsl:variable>
<xsl:key name="product" match="/items/item/products/product/text()" use="." />
  
<xsl:template match="report">Date,User,Activity,Start Time,End Time,Duration,Comments
<xsl:for-each select="entries/entry">
	<xsl:variable name="resourceId" select="resource_id"/>
	<xsl:variable name="projectId" select="project_id"/>
<xsl:value-of select="date"/>,<xsl:call-template name="display_csv_field"><xsl:with-param name="field" select="../../people/person[resource_id = $resourceId]/name"/></xsl:call-template>,<xsl:call-template name="display_csv_path"><xsl:with-param name="path" select="../../projects/project[project_id = $projectId]/path"/></xsl:call-template>,<xsl:value-of select="start_time_stamp_formatted"/>,<xsl:value-of select="end_time_stamp_formatted"/>,<xsl:call-template name="minutesToHours"><xsl:with-param name="minutes" select="duration div 60000"/></xsl:call-template>,<xsl:call-template name="display_csv_field"><xsl:with-param name="field" select="comments"/></xsl:call-template>
<xsl:text>
</xsl:text>
</xsl:for-each></xsl:template>
	
<xsl:template match="text()" name="toExtendedName"><xsl:param name="pText" select="."/><xsl:if test="string-length($pText)"><xsl:if test="not($pText=.)"> / </xsl:if><xsl:variable name="theId" select="substring-before(concat($pText, '.'), '.')"/><xsl:value-of select="/report/projects/project[project_id=$theId]/name"/><xsl:call-template name="toExtendedName"><xsl:with-param name="pText" select="substring-after($pText, '.')"/></xsl:call-template></xsl:if></xsl:template>
	
<xsl:template name="minutesToHours"><xsl:param name="minutes"/><xsl:value-of select="floor($minutes div 60)"/>:<xsl:if test="$minutes mod 60 &lt; 10">0</xsl:if><xsl:value-of select="$minutes mod 60"/></xsl:template>

<!-- figures out the path and then escapes it for CSV -->
<xsl:template name="display_csv_path">
	<xsl:param name="path"/>
	<xsl:variable name="fullPath">
		<xsl:apply-templates select="$path"/>
	</xsl:variable>
	<xsl:call-template name="display_csv_field">
		<xsl:with-param name="field" select="$fullPath"/>
	</xsl:call-template>
</xsl:template>	

<!-- escapes a string to make it CSV safe -->
<xsl:template name="display_csv_field">
    <xsl:param name="field"/>

    <xsl:variable name="linefeed">
      <xsl:text>&#10;</xsl:text>
    </xsl:variable>

    <xsl:choose>

    <xsl:when test="contains( $field, '&quot;' )">
      <!-- Field contains a quote. We must enclose this field in quotes,
           and we must escape each of the quotes in the field value.
      -->
      <xsl:text>"</xsl:text>

      <xsl:call-template name="escape_quotes">
        <xsl:with-param name="string" select="$field" />
      </xsl:call-template>

      <xsl:text>"</xsl:text>
    </xsl:when>

    <xsl:when test="contains( $field, ',' ) or
                    contains( $field, $linefeed )" >
      <!-- Field contains a comma and/or a linefeed.
           We must enclose this field in quotes.
      -->
      <xsl:text>"</xsl:text>
      <xsl:value-of select="$field" />
      <xsl:text>"</xsl:text>
    </xsl:when>

    <xsl:otherwise>
      <!-- No need to enclose this field in quotes.
      -->
      <xsl:value-of select="$field" />
    </xsl:otherwise>

    </xsl:choose>
  </xsl:template>

  <xsl:template name="escape_quotes">
    <xsl:param name="string" />

    <xsl:value-of select="substring-before( $string, '&quot;' )" />
    <xsl:text>""</xsl:text>

    <xsl:variable name="substring_after_first_quote"
                  select="substring-after( $string, '&quot;' )" />

    <xsl:choose>

    <xsl:when test="not( contains( $substring_after_first_quote,'&quot;' ) )">
      <xsl:value-of select="$substring_after_first_quote" />
    </xsl:when>

    <xsl:otherwise>
      <!-- The substring after the first quote contains a quote.
           So, we call ourself recursively to escape the quotes
           in the substring after the first quote.
      -->

      <xsl:call-template name="escape_quotes">
        <xsl:with-param name="string" select="$substring_after_first_quote"/>
      </xsl:call-template>
    </xsl:otherwise>

    </xsl:choose>

  </xsl:template>
  </xsl:stylesheet>	